<?php
require_once 'auth.php';
if (!Auth::isLoggedIn()) {
    header('Location: index.php');
    exit;
}

require_once 'config.php';
require_once 'ExamManager.php';

$db = Config::getDB();
$user_id = $_SESSION['user_id'];

// Get available exams
$stmt = $db->prepare("SELECT * FROM exams WHERE is_active = TRUE");
$stmt->execute();
$exams = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Check exam status for each exam
$exam_status = [];
$exam_history = [];
$attempt_counts = [];

foreach ($exams as $exam) {
    $exam_status[$exam['id']] = ExamManager::hasActiveAttempt($user_id, $exam['id']);
    $exam_history[$exam['id']] = ExamManager::getExamHistory($user_id, $exam['id']);
    $attempt_counts[$exam['id']] = ExamManager::getAttemptCount($user_id, $exam['id']);
}

$courseSel = ExamManager::courseEnrolled($user_id);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - CBT System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="icon" type="image/png" href="brainpals_logo.png">

</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="#">CBT System</a>
            <div class="navbar-nav ms-auto">
                <span class="navbar-text me-3"></span>
                <a href="logout.php" class="btn btn-outline-light">Logout</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="col-md-12">
        <h3>Welcome, <?= $_SESSION['username'] ?></h3>
        <h2 class="text-center text-uppercase text-uppercase">Available Exams</h2>
        </div>
        <div class="row">
            <?php foreach ($exams as $exam): 
                $has_active_attempt = $exam_status[$exam['id']];
                $attempt_count = $attempt_counts[$exam['id']];
                $exam_history_data = $exam_history[$exam['id']];
            ?>
            <div class="col-md-4 mb-3">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title"><?= $exam['name'] ?></h5>
                        <p class="card-text">
                            Questions: <?= $exam['total_questions'] ?><br>
                            Duration: <?= floor($exam['duration_seconds'] / 60) ?> minutes<br>
                            Points per correct: <?= $exam['points_per_correct'] ?><br>
                            Attempts: <?= $attempt_count ?> <br>
                            <strong>Course Selected:</strong> <?php  echo  ExamManager::getUserCourse($courseSel);   ?>(&#8358;<b><?php  $actualFee = ExamManager::getUserCourseCost($courseSel); 
                            echo number_format($actualFee,2);
                            ?></b>) <br>
                            <strong>Registeration & AI Course FEE: </strong>  <?php   $fape = ExamManager::getRegFape($courseSel);  
                            echo number_format($fape,2);
                            ?><span style="font-size:10px;color:red;">(This is not covered by the scholarship)</span> <br>
                            <strong>Total: </strong>  <strong><?php  $totalCostNow =  $fape+$actualFee; 
                            echo '&#8358;'. number_format($totalCostNow,2);
                            ?></strong> <br>
                        </p>
                        
                        <?php if ($has_active_attempt): ?>
                            <div class="alert alert-warning">
                                <strong>Exam in Progress!</strong> You have an active attempt.
                            </div>
                            <a href="exam.php?exam_id=<?= $exam['id'] ?>" class="btn btn-warning">Continue Exam</a>
                        <?php else: ?>
                            <?php if ($attempt_count > 0): ?>
                                <?php 
                                $best_score = 0;
                                if (!empty($exam_history_data)) {
                                    $scores = array_column($exam_history_data, 'total_score');
                                    $best_score = max($scores);
                                }
                                ?>
                                <div class="alert alert-info">
                                    <strong>Previous Attempts:</strong> <?= $attempt_count ?><br>
                                    <strong>Best Score:</strong> <?= $best_score; ?>%
                                <?php $totalEarned = $best_score+30;?>
                                <p>Total Scholarships Offer: <?php echo $totalEarned;  ?>% <br>
                                <?php   $calc = $actualFee*(1-$totalEarned/100) + $fape;
                                echo '<h4>&#8358;'.number_format($calc,2).'</h4> congratulations';
                                ?>


                                </p>




                                </div>
                                <a href="exam.php?exam_id=<?= $exam['id'] ?>" class="btn btn-primary">Retake Exam</a>
                            <?php else: ?>
                                <a href="exam.php?exam_id=<?= $exam['id'] ?>" class="btn btn-primary">Start Exam</a>
                            <?php endif; ?>
                        <?php endif; ?>
                      <div class="col-md-12 mt-2 tapCost mb-2">
                        <p id="courseInfo"></p>
                        <?php 
$stmt = $db->prepare("
    SELECT id, crs_title, course_name 
    FROM courses 
    WHERE id IN (1,2,3,5,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,29,32,35,36,37,48,49,58,65,69) 
    ORDER BY crs_title");
$stmt->execute();$courses = $stmt->fetchAll(PDO::FETCH_ASSOC);?>
<select name="course_sel" id="course_sel" class="form-select">
    <option value="">-- Select a Course --</option>
    <?php foreach ($courses as $crs): ?>
        <option value="<?= htmlspecialchars($crs['id']) ?>">
            <?= htmlspecialchars($crs['crs_title']) ?>
        </option>
    <?php endforeach; ?>
</select>


</div>
                        
                            <a href=""  class="btn btn-outline-secondary btn-sm ms-2 showSelect btn-success text-white">Change Course</a>

                       
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <script>
$(document).ready(function() {
    let percent = <?= json_encode($totalEarned) ?>; 

    $('#course_sel').on('change', function() {
        let courseId = $(this).val();

        if(courseId) {
            $.ajax({
                url: 'ajax_get_course.php',
                type: 'POST',
                data: { 
                    id: courseId, 
                    percent: percent  
                },
                success: function(response) {
                    $('#courseInfo').html(response);
                },
                error: function() {
                    $('#courseInfo').html('<p class="text-danger">Error loading course info.</p>');
                }
            });
        } else {
            $('#courseInfo').html('');
        }
    });
    $('.tapCost').hide();
$('.showSelect').click(function(e){e.preventDefault();
    $('.tapCost').toggle();
})

});
</script>
</body>
</html>