<?php
session_start();

class Config {
    const DB_HOST = 'localhost';
    const DB_NAME = 'cbt_sys';
    const DB_USER = 'root';
    const DB_PASS = '';
    
    // Exam configuration (can be overridden per exam)
    const TOTAL_QUESTIONS = 5;
    const EXAM_DURATION_SECONDS = 300; // 5 minutes
    const POINTS_PER_CORRECT = 1.0;
    const AUTOSAVE_INTERVAL = 10; // seconds
    
    public static function getDB() {
        static $db = null;
        if ($db === null) {
            try {
                $db = new PDO(
                    "mysql:host=" . self::DB_HOST . ";dbname=" . self::DB_NAME . ";charset=utf8",
                    self::DB_USER,
                    self::DB_PASS,
                    [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
                );
            } catch (PDOException $e) {
                error_log("Database connection failed: " . $e->getMessage());
                die("Database connection failed");
            }
        }
        return $db;
    }
    
    public static function sanitize($data) {
        return htmlspecialchars(strip_tags(trim($data)));
    }
}
?>