<?php
require_once 'auth.php';

// If already logged in as admin, redirect to admin dashboard
if (Auth::isLoggedIn() && Auth::isAdmin()) {
    header('Location: admin_dashboard.php');
    exit;
}

$error = '';

if ($_POST['action'] ?? '' === 'login') {
    $username = Config::sanitize($_POST['username']);
    $password = $_POST['password'];
    
    if (Auth::login($username, $password)) {
        if (Auth::isAdmin()) {
            header('Location: admin_dashboard.php');
            exit;
        } else {
            $error = "Access denied. Admin privileges required.";
            Auth::logout(); // Log out non-admin users
        }
    } else {
        $error = "Invalid login credentials";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - CBT System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="brainpals_logo.png">
    <style>
        .admin-login {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        .login-card {
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            border: none;
            border-radius: 15px;
        }
    </style>
</head>
<body class="admin-login">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-5">
                <div class="card login-card">
                    <div class="card-header bg-dark text-white text-center">
                        <h4><i class="fas fa-lock me-2"></i>Admin Login</h4>
                        <p class="mb-0">CBT System Administration</p>
                    </div>
                    <div class="card-body p-4">
                        <?php if ($error): ?>
                            <div class="alert alert-danger"><?= $error ?></div>
                        <?php endif; ?>
                        
                        <form method="POST">
                            <input type="hidden" name="action" value="login">
                            <div class="mb-3">
                                <label class="form-label">Username</label>
                                <input type="text" name="username" class="form-control" required autofocus>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Password</label>
                                <input type="password" name="password" class="form-control" required>
                            </div>
                            <button type="submit" class="btn btn-dark w-100">Login as Admin</button>
                        </form>
                        
                        <div class="text-center mt-3">
                            <a href="index.php" class="text-muted">← Back to Student Login</a>
                        </div>
                    </div>
                    <div class="card-footer text-center text-muted small">
                        <p>Default admin credentials:<br>
                        <strong>Username:</strong> admin<br>
                        <strong>Password:</strong> password</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>