<?php
require_once 'auth.php';
if (!Auth::isLoggedIn()) {header('Location: admin_login.php');
    exit;
}

if (!Auth::isAdmin()) {
    header('Location: dashboard.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - CBT System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="#">CBT System - Admin</a>
            <div class="navbar-nav ms-auto">
                <a href="logout.php" class="nav-link">Logout</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <h2>Admin Dashboard</h2>
        <div class="row mt-4">
            <div class="col-md-3 mb-3">
                <div class="card text-white bg-primary">
                    <div class="card-body">
                        <h5 class="card-title">View Results</h5>
                        <p class="card-text">Examine student performance and scores</p>
                        <a href="admin_results.php" class="btn btn-light">Go to Results</a>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card text-white bg-success">
                    <div class="card-body">
                        <h5 class="card-title">Manage Exams</h5>
                        <p class="card-text">Create and edit exams</p>
                        <a href="admin_exams.php" class="btn btn-light">Manage Exams</a>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card text-white bg-warning">
                    <div class="card-body">
                        <h5 class="card-title">Manage Questions</h5>
                        <p class="card-text">Add/edit exam questions</p>
                        <a href="admin_questions.php" class="btn btn-light">Manage Questions</a>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card text-white bg-info">
                    <div class="card-body">
                        <h5 class="card-title">User Management</h5>
                        <p class="card-text">Manage students and administrators</p>
                        <a href="admin_users.php" class="btn btn-light">Manage Users</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>