<?php
require_once 'ExamManager.php';
require_once 'auth.php';

if (!Auth::isLoggedIn()) {
    die(json_encode(['success' => false, 'error' => 'Unauthorized']));
}

$session_id = intval($_POST['session_id'] ?? 0);

if ($session_id === 0) {
    die(json_encode(['success' => false, 'error' => 'Invalid session']));
}

$result = ExamManager::submitExam($session_id);

if ($result) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'error' => 'Failed to submit exam']);
}
?>