<?php
include 'topmost.php';
ini_set('max_execution_time', '0');
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<title>My Outlet</title>

<?php include 'toplinks.php'; ?>
</head>

<body id="page-top">
<div id="wrapper">

<?php include 'menus.php'; ?>
<?php include 'top.php'; ?>

<div class="container-fluid">

<!-- Page Heading -->
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <?php include 'greet.php'; ?>
    <?php include 'process.php'; ?>
</div>

<!-- SUMMARY CARDS -->
<div class="row">

<div class="col-xl-4 col-md-6 mb-4">
    <div class="card border-left-primary shadow h-100 py-2">
        <div class="card-body">
            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                Total Products In Stock
            </div>
            <div class="h5 mb-0 font-weight-bold text-gray-800">
                <?= QueryDB("SELECT COUNT(*) FROM products")->fetchColumn(); ?>
            </div>
        </div>
    </div>
</div>

<div class="col-xl-4 col-md-6 mb-4">
    <div class="card border-left-success shadow h-100 py-2">
        <div class="card-body">
            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                Total Branches
            </div>
            <div class="h5 mb-0 font-weight-bold text-gray-800">
                <?= QueryDB("SELECT COUNT(*) FROM branch")->fetchColumn(); ?>
            </div>
        </div>
    </div>
</div>

<div class="col-xl-4 col-md-6 mb-4">
    <div class="card border-left-info shadow h-100 py-2">
        <div class="card-body">
            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                Warehouse Product Count
            </div>
            <div class="h5 mb-0 font-weight-bold text-gray-800">
                <?php
                $qty = QueryDB("SELECT SUM(item_qty) FROM storekeeper")->fetchColumn();
                echo $qty ?: 0;
                ?>
            </div>
        </div>
    </div>
</div>

</div>

<!-- STOCK TABLE -->
<div class="card shadow mb-4">
<div class="card-header py-3 d-flex justify-content-between align-items-center bg-success text-white">
    <h6 class="m-0 font-weight-bold">Warehouse Stock View</h6>
    <button class="btn btn-dark btn-sm" id="exp_whrhs_stock">
        <i class="fa fa-file-excel"></i> Export CSV
    </button>
</div>

<div class="card-body">
<div class="table-responsive">

<table class="table table-bordered whrhs_stock std_table" id="dataTable" width="100%" cellspacing="0">
<thead>
<tr class="small">
    <th>#</th>
    <th>Name</th>
    <th>Size</th>
    <th>Color</th>
    <th>Category</th>
    <th>Company</th>
    <th>Cost</th>
    <th>Image</th>
    <th>Last Stock Date</th>
    <th>Last Qty</th>
    <th>Total Loaded</th>
    <th>Total Supplied</th>
    <th>Current Qty</th>
    <th class="noExl">Action</th>
</tr>
</thead>

<tbody>
<?php
$count = 1;
$products = QueryDB("SELECT * FROM products WHERE tm_status = 1");

foreach ($products as $p) {

    $lastStock   = lastStockWhouse($p['id'], '', '');
    $totalLoad  = totalStockWHouse($p['id'], '', '');
    $supplied   = totalStockSupplied($p['id'], '', "AND load_code!=''");
    $currentQty = $totalLoad - abs($supplied);

    $img = '';
    if (!empty($p['item_img'])) {
        $imgPath = explode(',', $p['item_img'])[0];
        if (file_exists($imgPath)) {
            $img = '<img src="'.$imgPath.'" class="img-thumbnail" style="height:70px">';
        }
    }
?>
<tr class="small">
    <td><?= $count ?></td>
    <td><?= htmlspecialchars($p['item_name']) ?></td>
    <td><?= $sized_by[$p['size']] ?? '-' ?></td>
    <td><?= $colored_by[$p['color']] ?? '-' ?></td>
    <td><?= $brand[$p['brand']] ?? '-' ?></td>
    <td><?= $company[$p['company']] ?? '-' ?></td>
    <td>&#8358;<?= number_format($p['item_cost'], 2) ?></td>
    <td><?= $img ?></td>
    <td><?= !empty($lastStock['item_time']) ? date('D jS M, Y', $lastStock['item_time']) : '-' ?></td>
    <td><?= $lastStock['item_qty'] ?? 0 ?></td>
    <td><?= $totalLoad ?></td>
    <td><?= abs($supplied) ?></td>
    <td><?= $currentQty ?></td>
    <td class="noExl">
        <a href="whrs_itemView?sel_product=<?= $p['id'] ?>" class="btn btn-info btn-sm">
            Supply History
        </a>
    </td>
</tr>
<?php
$count++;
}
?>
</tbody>
</table>

</div>
</div>
</div>

</div><!-- /.container-fluid -->
</div><!-- End Main Content -->

<?php include 'bottom_most.php'; ?>

<script>
var exportTitle = "<?= date('D jS F Y'); ?> Warehouse Stock Inventory";

$('#exp_whrhs_stock').on('click', function () {
    $(".whrhs_stock").table2excel({
        exclude: ".noExl",
        name: "Warehouse Stock",
        filename: exportTitle + ".xls",
        fileext: ".xls",
        exclude_img: true,
        exclude_links: true,
        exclude_inputs: true
    });
});
</script>

</body>
</html>
